<?php

add_theme_support( 'post-thumbnails' );

 # code...
    register_nav_menus(
        array(
            'menu-header' => __( 'Main', 'main_menu' ),
            'footer-quick' => __( 'Footer Quick', 'footer_quick' ),
            'footer-popular' => __( 'Footer Popular', 'footer_popular' ),
        )
    );


function halexo() {
    wp_enqueue_style( 'font-awesome', "https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css", array(), wp_get_theme()->get( 'Version' ) );
    wp_enqueue_style( 'bootstrap-icons', "https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css", array(), wp_get_theme()->get( 'Version' ) );
    wp_enqueue_style( 'owlcarousel-css', get_theme_file_uri('/assets/lib/owlcarousel/assets/owl.carousel.min.css'), array(), wp_get_theme()->get( 'Version' ) );
    wp_enqueue_style( 'animate-css', get_theme_file_uri('/assets/lib/animate/animate.min.css'), array(), wp_get_theme()->get( 'Version' ) );
    wp_enqueue_style( 'bootstrap-min-css', get_theme_file_uri('/assets/css/bootstrap.min.css'), array(), wp_get_theme()->get( 'Version' ) );
    wp_enqueue_style( 'style-css', get_theme_file_uri('/assets/css/style.css'), array(), wp_get_theme()->get( 'Version' ) );
    wp_enqueue_style( 'main-css', get_theme_file_uri('/assets/css/custom.css'), array(), wp_get_theme()->get( 'Version' ) );

    wp_enqueue_script('jquery-js', 'https://code.jquery.com/jquery-3.4.1.min.js', array(), true);
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js', array(), true);
    wp_enqueue_script( 'wow-js', get_theme_file_uri( '/assets/lib/wow/wow.min.js' ), array(), '1.1', true );
    wp_enqueue_script( 'easing-js', get_theme_file_uri( '/assets/lib/easing/easing.min.js' ), array(), '1.1', true );
    wp_enqueue_script( 'waypoints-js', get_theme_file_uri( '/assets/lib/waypoints/waypoints.min.js' ), array(), '1.1', true );
    wp_enqueue_script( 'counterup-js', get_theme_file_uri( '/assets/lib/counterup/counterup.min.js' ), array(), '1.1', true );
    wp_enqueue_script( 'owlcarousel-js', get_theme_file_uri( '/assets/lib/owlcarousel/owl.carousel.min.js' ), array(), '1.1', true );
    wp_enqueue_script( 'main-js', get_theme_file_uri( '/assets/js/main.js' ), array(), '1.1', true );

//     if (is_front_page() ) {
//         wp_dequeue_script( 'cam_1', get_theme_file_uri( '/assets/js/jquery-3.5.1.min.js' ), array(), '1.1', true );
//     }
}

add_action( 'wp_enqueue_scripts', 'halexo' );

if( function_exists('acf_add_options_page') ) {

    acf_add_options_page(array(
        'page_title'    => 'Theme General Settings',
        'menu_title'    => 'Theme Settings',
        'menu_slug'     => 'theme-general-settings',
        'capability'    => 'edit_posts',
        'redirect'      => false
    ));
    
    acf_add_options_sub_page(array(
        'page_title'    => 'Theme Footer Settings',
        'menu_title'    => 'Footer',
        'parent_slug'   => 'theme-general-settings',
    ));
    
}

 wp_enqueue_style( 'dashicons' );
    
define('IMG_PATH', get_template_directory_uri().'/assets/img/');
define('VID_PATH', get_template_directory_uri().'/assets/video/');

function bittersweet_pagination() {
global $wp_query;
if ( $wp_query->max_num_pages <= 1 ) return;
$big = 999999999; // need an unlikely integer
$pages = paginate_links( array(
        'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
        'format' => '?paged=%#%',
        'current' => max( 1, get_query_var('paged') ),
        'total' => $wp_query->max_num_pages,
        'type'  => 'array',
    ) );
    if( is_array( $pages ) ) {
        $paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
        echo '<nav class="pagination-wrap"><ul class="pagination justify-content-center">';
        foreach ( $pages as $page ) {
                echo "<li>$page</li>";
        }
        echo '</ul></nav>';
        }
}

class Anchor_Only_Walker extends Walker_Nav_Menu {
    // Override the start_el() method
    function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
        $attributes  = !empty( $item->attr_title ) ? ' title="' . esc_attr( $item->attr_title ) . '"' : '';
        $attributes .= !empty( $item->target ) ? ' target="' . esc_attr( $item->target ) . '"' : '';
        $attributes .= !empty( $item->xfn ) ? ' rel="' . esc_attr( $item->xfn ) . '"' : '';
        $attributes .= !empty( $item->url ) ? ' href="' . esc_attr( $item->url ) . '"' : '';

        // Fetch CSS classes added via the Admin panel
        $classes = !empty( $item->classes ) ? implode( ' ', array_map( 'esc_attr', $item->classes ) ) : '';
        
        // Add classes to the <a> tag
        $attributes .= !empty( $classes ) ? ' class="' . $classes . '"' : '';

        $item_output = '<a' . $attributes . '>';
        $item_output .= apply_filters( 'the_title', $item->title, $item->ID );
        $item_output .= '</a>';

        $output .= $item_output;
    }

    // Prevent wrapping output with <ul> or <li>
    function start_lvl(&$output, $depth = 0, $args = null) {}
    function end_lvl(&$output, $depth = 0, $args = null) {}
    function end_el(&$output, $item, $depth = 0, $args = null) {}
}
